import {
        async,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from '@angular/http'
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { FhirPractitionerComponent } from './practitioner.component';
import { FhirPractitioner } from '../../../mccf-data/fhir/fhir-practitioner'

describe('FhirPractitionerComponent', () => {
  let component: FhirPractitionerComponent
  let fixture: ComponentFixture<FhirPractitionerComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        FhirPractitionerComponent
      ],
      providers: []
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(FhirPractitionerComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    let prac = new FhirPractitioner()
    prac.accessCode = '123456'
    component.prac = prac
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have a practitioner loaded', ((done)=>{
    expect(component.prac.accessCode).toEqual('123456')
    done()
  }))

  it('should have no accessibility issues', ((done) => {
    //console.error(' @@@@@@@@@@@@@ html='+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error('AXE-CORE ERROR:'+error)
    })
  }))
})
